package io.burkard.cdk.services.cloudfront

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Behavior {

  def apply(
    forwardedValues: Option[software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty] = None,
    trustedKeyGroups: Option[List[_ <: software.amazon.awscdk.services.cloudfront.IKeyGroup]] = None,
    defaultTtl: Option[software.amazon.awscdk.Duration] = None,
    functionAssociations: Option[List[_ <: software.amazon.awscdk.services.cloudfront.FunctionAssociation]] = None,
    allowedMethods: Option[software.amazon.awscdk.services.cloudfront.CloudFrontAllowedMethods] = None,
    isDefaultBehavior: Option[Boolean] = None,
    pathPattern: Option[String] = None,
    lambdaFunctionAssociations: Option[List[_ <: software.amazon.awscdk.services.cloudfront.LambdaFunctionAssociation]] = None,
    viewerProtocolPolicy: Option[software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy] = None,
    maxTtl: Option[software.amazon.awscdk.Duration] = None,
    compress: Option[Boolean] = None,
    minTtl: Option[software.amazon.awscdk.Duration] = None,
    cachedMethods: Option[software.amazon.awscdk.services.cloudfront.CloudFrontAllowedCachedMethods] = None
  ): software.amazon.awscdk.services.cloudfront.Behavior =
    (new software.amazon.awscdk.services.cloudfront.Behavior.Builder)
      .forwardedValues(forwardedValues.orNull)
      .trustedKeyGroups(trustedKeyGroups.map(_.asJava).orNull)
      .defaultTtl(defaultTtl.orNull)
      .functionAssociations(functionAssociations.map(_.asJava).orNull)
      .allowedMethods(allowedMethods.orNull)
      .isDefaultBehavior(isDefaultBehavior.map(Boolean.box).orNull)
      .pathPattern(pathPattern.orNull)
      .lambdaFunctionAssociations(lambdaFunctionAssociations.map(_.asJava).orNull)
      .viewerProtocolPolicy(viewerProtocolPolicy.orNull)
      .maxTtl(maxTtl.orNull)
      .compress(compress.map(Boolean.box).orNull)
      .minTtl(minTtl.orNull)
      .cachedMethods(cachedMethods.orNull)
      .build()
}
