package io.burkard.cdk.services.billingconductor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPricingPlanProps {

  def apply(
    name: String,
    description: Option[String] = None,
    pricingRuleArns: Option[List[String]] = None
  ): software.amazon.awscdk.services.billingconductor.CfnPricingPlanProps =
    (new software.amazon.awscdk.services.billingconductor.CfnPricingPlanProps.Builder)
      .name(name)
      .description(description.orNull)
      .pricingRuleArns(pricingRuleArns.map(_.asJava).orNull)
      .build()
}
