package io.burkard.cdk.services.billingconductor

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBillingGroup {

  def apply(
    internalResourceId: String,
    name: String,
    primaryAccountId: String,
    accountGrouping: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.AccountGroupingProperty,
    computationPreference: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.ComputationPreferenceProperty,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.billingconductor.CfnBillingGroup =
    software.amazon.awscdk.services.billingconductor.CfnBillingGroup.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .primaryAccountId(primaryAccountId)
      .accountGrouping(accountGrouping)
      .computationPreference(computationPreference)
      .description(description.orNull)
      .build()
}
