package io.burkard.cdk.services.athena

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPreparedStatementProps {

  def apply(
    queryStatement: String,
    statementName: String,
    workGroup: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.athena.CfnPreparedStatementProps =
    (new software.amazon.awscdk.services.athena.CfnPreparedStatementProps.Builder)
      .queryStatement(queryStatement)
      .statementName(statementName)
      .workGroup(workGroup)
      .description(description.orNull)
      .build()
}
