package io.burkard.cdk.services.apigateway

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object JsonSchema {

  def apply(
    exclusiveMaximum: Option[Boolean] = None,
    format: Option[String] = None,
    pattern: Option[String] = None,
    description: Option[String] = None,
    anyOf: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    patternProperties: Option[Map[String, _ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    items0: Option[software.amazon.awscdk.services.apigateway.JsonSchema] = None,
    items1: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    additionalItems: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    maxProperties: Option[Number] = None,
    ref: Option[String] = None,
    enumValue: Option[List[_]] = None,
    maxItems: Option[Number] = None,
    maximum: Option[Number] = None,
    multipleOf: Option[Number] = None,
    id: Option[String] = None,
    schema: Option[software.amazon.awscdk.services.apigateway.JsonSchemaVersion] = None,
    properties: Option[Map[String, _ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    exclusiveMinimum: Option[Boolean] = None,
    additionalProperties0: Option[Boolean] = None,
    additionalProperties1: Option[software.amazon.awscdk.services.apigateway.JsonSchema] = None,
    minItems: Option[Number] = None,
    not: Option[software.amazon.awscdk.services.apigateway.JsonSchema] = None,
    definitions: Option[Map[String, _ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    minLength: Option[Number] = None,
    title: Option[String] = None,
    minimum: Option[Number] = None,
    type0: Option[software.amazon.awscdk.services.apigateway.JsonSchemaType] = None,
    type1: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchemaType]] = None,
    required: Option[List[String]] = None,
    defaultValue: Option[AnyRef] = None,
    contains0: Option[software.amazon.awscdk.services.apigateway.JsonSchema] = None,
    contains1: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    oneOf: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None,
    uniqueItems: Option[Boolean] = None,
    minProperties: Option[Number] = None,
    propertyNames: Option[software.amazon.awscdk.services.apigateway.JsonSchema] = None,
    dependencies: Option[Map[String, _]] = None,
    maxLength: Option[Number] = None,
    allOf: Option[List[_ <: software.amazon.awscdk.services.apigateway.JsonSchema]] = None
  ): software.amazon.awscdk.services.apigateway.JsonSchema =
    (new software.amazon.awscdk.services.apigateway.JsonSchema.Builder)
      .exclusiveMaximum(exclusiveMaximum.map(Boolean.box).orNull)
      .format(format.orNull)
      .pattern(pattern.orNull)
      .description(description.orNull)
      .anyOf(anyOf.map(_.asJava).orNull)
      .patternProperties(patternProperties.map(_.asJava).orNull)
      .items(items0.orNull)
      .items(items1.map(_.asJava).orNull)
      .additionalItems(additionalItems.map(_.asJava).orNull)
      .maxProperties(maxProperties.orNull)
      .ref(ref.orNull)
      .enumValue(enumValue.map(_.asJava).orNull)
      .maxItems(maxItems.orNull)
      .maximum(maximum.orNull)
      .multipleOf(multipleOf.orNull)
      .id(id.orNull)
      .schema(schema.orNull)
      .properties(properties.map(_.asJava).orNull)
      .exclusiveMinimum(exclusiveMinimum.map(Boolean.box).orNull)
      .additionalProperties(additionalProperties0.map(Boolean.box).orNull)
      .additionalProperties(additionalProperties1.orNull)
      .minItems(minItems.orNull)
      .not(not.orNull)
      .definitions(definitions.map(_.asJava).orNull)
      .minLength(minLength.orNull)
      .title(title.orNull)
      .minimum(minimum.orNull)
      .`type`(type0.orNull)
      .`type`(type1.map(_.asJava).orNull)
      .required(required.map(_.asJava).orNull)
      .defaultValue(defaultValue.orNull)
      .contains(contains0.orNull)
      .contains(contains1.map(_.asJava).orNull)
      .oneOf(oneOf.map(_.asJava).orNull)
      .uniqueItems(uniqueItems.map(Boolean.box).orNull)
      .minProperties(minProperties.orNull)
      .propertyNames(propertyNames.orNull)
      .dependencies(dependencies.map(_.asJava).orNull)
      .maxLength(maxLength.orNull)
      .allOf(allOf.map(_.asJava).orNull)
      .build()
}
