package io.burkard.cdk.cxapi

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcSubnet {

  def apply(
    availabilityZone: String,
    subnetId: String,
    routeTableId: String,
    cidr: Option[String] = None
  ): software.amazon.awscdk.cxapi.VpcSubnet =
    (new software.amazon.awscdk.cxapi.VpcSubnet.Builder)
      .availabilityZone(availabilityZone)
      .subnetId(subnetId)
      .routeTableId(routeTableId)
      .cidr(cidr.orNull)
      .build()
}
