package io.burkard.cdk.services.refactorspaces.cfnRoute

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UriPathRouteInputProperty {

  def apply(
    activationState: String,
    methods: Option[List[String]] = None,
    sourcePath: Option[String] = None,
    includeChildPaths: Option[Boolean] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty =
    (new software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty.Builder)
      .activationState(activationState)
      .methods(methods.map(_.asJava).orNull)
      .sourcePath(sourcePath.orNull)
      .includeChildPaths(includeChildPaths.map(Boolean.box).orNull)
      .build()
}
