package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailChannelProps {

  def apply(
    applicationId: String,
    fromAddress: String,
    identity: String,
    enabled: Option[Boolean] = None,
    configurationSet: Option[String] = None,
    roleArn: Option[String] = None
  ): software.amazon.awscdk.services.pinpoint.CfnEmailChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnEmailChannelProps.Builder)
      .applicationId(applicationId)
      .fromAddress(fromAddress)
      .identity(identity)
      .enabled(enabled.map(Boolean.box).orNull)
      .configurationSet(configurationSet.orNull)
      .roleArn(roleArn.orNull)
      .build()
}
