package io.burkard.cdk.services.networkfirewall

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLoggingConfiguration {

  def apply(
    internalResourceId: String,
    firewallArn: String,
    loggingConfiguration: software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.LoggingConfigurationProperty,
    firewallName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration =
    software.amazon.awscdk.services.networkfirewall.CfnLoggingConfiguration.Builder
      .create(stackCtx, internalResourceId)
      .firewallArn(firewallArn)
      .loggingConfiguration(loggingConfiguration)
      .firewallName(firewallName.orNull)
      .build()
}
