package io.burkard.cdk.services.kinesisvideo

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStream {

  def apply(
    internalResourceId: String,
    deviceName: Option[String] = None,
    mediaType: Option[String] = None,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dataRetentionInHours: Option[Number] = None,
    kmsKeyId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.kinesisvideo.CfnStream =
    software.amazon.awscdk.services.kinesisvideo.CfnStream.Builder
      .create(stackCtx, internalResourceId)
      .deviceName(deviceName.orNull)
      .mediaType(mediaType.orNull)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .dataRetentionInHours(dataRetentionInHours.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
