package io.burkard.cdk.services.kafkaconnect.cfnConnector

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AutoScalingProperty {

  def apply(
    mcuCount: Number,
    maxWorkerCount: Number,
    scaleInPolicy: software.amazon.awscdk.services.kafkaconnect.CfnConnector.ScaleInPolicyProperty,
    minWorkerCount: Number,
    scaleOutPolicy: software.amazon.awscdk.services.kafkaconnect.CfnConnector.ScaleOutPolicyProperty
  ): software.amazon.awscdk.services.kafkaconnect.CfnConnector.AutoScalingProperty =
    (new software.amazon.awscdk.services.kafkaconnect.CfnConnector.AutoScalingProperty.Builder)
      .mcuCount(mcuCount)
      .maxWorkerCount(maxWorkerCount)
      .scaleInPolicy(scaleInPolicy)
      .minWorkerCount(minWorkerCount)
      .scaleOutPolicy(scaleOutPolicy)
      .build()
}
