package io.burkard.cdk.services.fsx

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStorageVirtualMachineProps {

  def apply(
    name: String,
    fileSystemId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    svmAdminPassword: Option[String] = None,
    rootVolumeSecurityStyle: Option[String] = None,
    activeDirectoryConfiguration: Option[software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty] = None
  ): software.amazon.awscdk.services.fsx.CfnStorageVirtualMachineProps =
    (new software.amazon.awscdk.services.fsx.CfnStorageVirtualMachineProps.Builder)
      .name(name)
      .fileSystemId(fileSystemId)
      .tags(tags.map(_.asJava).orNull)
      .svmAdminPassword(svmAdminPassword.orNull)
      .rootVolumeSecurityStyle(rootVolumeSecurityStyle.orNull)
      .activeDirectoryConfiguration(activeDirectoryConfiguration.orNull)
      .build()
}
