package io.burkard.cdk.services.fis

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnExperimentTemplateProps {

  def apply(
    targets: Map[String, _],
    stopConditions: List[_],
    description: String,
    tags: Map[String, String],
    roleArn: String,
    actions: Option[Map[String, _]] = None,
    logConfiguration: Option[software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty] = None
  ): software.amazon.awscdk.services.fis.CfnExperimentTemplateProps =
    (new software.amazon.awscdk.services.fis.CfnExperimentTemplateProps.Builder)
      .targets(targets.asJava)
      .stopConditions(stopConditions.asJava)
      .description(description)
      .tags(tags.asJava)
      .roleArn(roleArn)
      .actions(actions.map(_.asJava).orNull)
      .logConfiguration(logConfiguration.orNull)
      .build()
}
