package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodePipeline {

  def apply(
    pipeline: software.amazon.awscdk.services.codepipeline.IPipeline,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.events.targets.CodePipeline =
    software.amazon.awscdk.services.events.targets.CodePipeline.Builder
      .create(pipeline)
      .eventRole(eventRole.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
