package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoggingOptions {

  def apply(
    slowSearchLogGroup: Option[software.amazon.awscdk.services.logs.ILogGroup] = None,
    slowIndexLogEnabled: Option[Boolean] = None,
    appLogEnabled: Option[Boolean] = None,
    appLogGroup: Option[software.amazon.awscdk.services.logs.ILogGroup] = None,
    auditLogEnabled: Option[Boolean] = None,
    slowSearchLogEnabled: Option[Boolean] = None,
    slowIndexLogGroup: Option[software.amazon.awscdk.services.logs.ILogGroup] = None,
    auditLogGroup: Option[software.amazon.awscdk.services.logs.ILogGroup] = None
  ): software.amazon.awscdk.services.elasticsearch.LoggingOptions =
    (new software.amazon.awscdk.services.elasticsearch.LoggingOptions.Builder)
      .slowSearchLogGroup(slowSearchLogGroup.orNull)
      .slowIndexLogEnabled(slowIndexLogEnabled.map(Boolean.box).orNull)
      .appLogEnabled(appLogEnabled.map(Boolean.box).orNull)
      .appLogGroup(appLogGroup.orNull)
      .auditLogEnabled(auditLogEnabled.map(Boolean.box).orNull)
      .slowSearchLogEnabled(slowSearchLogEnabled.map(Boolean.box).orNull)
      .slowIndexLogGroup(slowIndexLogGroup.orNull)
      .auditLogGroup(auditLogGroup.orNull)
      .build()
}
