package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIdentityProviderConfig {

  def apply(
    internalResourceId: String,
    `type`: String,
    clusterName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    oidc: Option[software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.OidcIdentityProviderConfigProperty] = None,
    identityProviderConfigName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.eks.CfnIdentityProviderConfig =
    software.amazon.awscdk.services.eks.CfnIdentityProviderConfig.Builder
      .create(stackCtx, internalResourceId)
      .`type`(`type`)
      .clusterName(clusterName)
      .tags(tags.map(_.asJava).orNull)
      .oidc(oidc.orNull)
      .identityProviderConfigName(identityProviderConfigName.orNull)
      .build()
}
