package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LinuxParameters {

  def apply(
    internalResourceId: String,
    sharedMemorySize: Option[Number] = None,
    initProcessEnabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ecs.LinuxParameters =
    software.amazon.awscdk.services.ecs.LinuxParameters.Builder
      .create(stackCtx, internalResourceId)
      .sharedMemorySize(sharedMemorySize.orNull)
      .initProcessEnabled(initProcessEnabled.map(Boolean.box).orNull)
      .build()
}
