package io.burkard.cdk.services.customerprofiles.cfnIntegration

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScheduledTriggerPropertiesProperty {

  def apply(
    scheduleExpression: String,
    dataPullMode: Option[String] = None,
    scheduleStartTime: Option[Number] = None,
    timezone: Option[String] = None,
    scheduleOffset: Option[Number] = None,
    firstExecutionFrom: Option[Number] = None,
    scheduleEndTime: Option[Number] = None
  ): software.amazon.awscdk.services.customerprofiles.CfnIntegration.ScheduledTriggerPropertiesProperty =
    (new software.amazon.awscdk.services.customerprofiles.CfnIntegration.ScheduledTriggerPropertiesProperty.Builder)
      .scheduleExpression(scheduleExpression)
      .dataPullMode(dataPullMode.orNull)
      .scheduleStartTime(scheduleStartTime.orNull)
      .timezone(timezone.orNull)
      .scheduleOffset(scheduleOffset.orNull)
      .firstExecutionFrom(firstExecutionFrom.orNull)
      .scheduleEndTime(scheduleEndTime.orNull)
      .build()
}
