package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfig {

  def apply(
    internalResourceId: String,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None,
    deploymentConfigName: Option[String] = None,
    computePlatform: Option[String] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .computePlatform(computePlatform.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .build()
}
