package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunction {

  def apply(
    internalResourceId: String,
    name: String,
    autoPublish: Option[Boolean] = None,
    functionCode: Option[String] = None,
    functionConfig: Option[software.amazon.awscdk.services.cloudfront.CfnFunction.FunctionConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.cloudfront.CfnFunction =
    software.amazon.awscdk.services.cloudfront.CfnFunction.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .autoPublish(autoPublish.map(Boolean.box).orNull)
      .functionCode(functionCode.orNull)
      .functionConfig(functionConfig.orNull)
      .build()
}
