package io.burkard.cdk.services.backup.cfnBackupPlan

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlanResourceTypeProperty {

  def apply(
    backupPlanName: String,
    backupPlanRule: List[_],
    advancedBackupSettings: Option[List[_]] = None
  ): software.amazon.awscdk.services.backup.CfnBackupPlan.BackupPlanResourceTypeProperty =
    (new software.amazon.awscdk.services.backup.CfnBackupPlan.BackupPlanResourceTypeProperty.Builder)
      .backupPlanName(backupPlanName)
      .backupPlanRule(backupPlanRule.asJava)
      .advancedBackupSettings(advancedBackupSettings.map(_.asJava).orNull)
      .build()
}
