package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object WarmPool {

  def apply(
    internalResourceId: String,
    autoScalingGroup: software.amazon.awscdk.services.autoscaling.IAutoScalingGroup,
    maxGroupPreparedCapacity: Option[Number] = None,
    reuseOnScaleIn: Option[Boolean] = None,
    poolState: Option[software.amazon.awscdk.services.autoscaling.PoolState] = None,
    minSize: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.autoscaling.WarmPool =
    software.amazon.awscdk.services.autoscaling.WarmPool.Builder
      .create(stackCtx, internalResourceId)
      .autoScalingGroup(autoScalingGroup)
      .maxGroupPreparedCapacity(maxGroupPreparedCapacity.orNull)
      .reuseOnScaleIn(reuseOnScaleIn.map(Boolean.box).orNull)
      .poolState(poolState.orNull)
      .minSize(minSize.orNull)
      .build()
}
