package io.burkard.cdk.services.waf.regional

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRateBasedRuleProps {

  def apply(
    name: String,
    metricName: String,
    rateLimit: Number,
    rateKey: String,
    matchPredicates: Option[List[_]] = None
  ): software.amazon.awscdk.services.waf.regional.CfnRateBasedRuleProps =
    (new software.amazon.awscdk.services.waf.regional.CfnRateBasedRuleProps.Builder)
      .name(name)
      .metricName(metricName)
      .rateLimit(rateLimit)
      .rateKey(rateKey)
      .matchPredicates(matchPredicates.map(_.asJava).orNull)
      .build()
}
