package io.burkard.cdk.services.stepfunctions.tasks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SageMakerCreateTransformJobProps {

  def apply(
    transformInput: software.amazon.awscdk.services.stepfunctions.tasks.TransformInput,
    transformJobName: String,
    modelName: String,
    transformOutput: software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput,
    maxPayload: Option[software.amazon.awscdk.Size] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    tags: Option[Map[String, String]] = None,
    batchStrategy: Option[software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy] = None,
    transformResources: Option[software.amazon.awscdk.services.stepfunctions.tasks.TransformResources] = None,
    resultPath: Option[String] = None,
    maxConcurrentTransforms: Option[Number] = None,
    integrationPattern: Option[software.amazon.awscdk.services.stepfunctions.IntegrationPattern] = None,
    outputPath: Option[String] = None,
    comment: Option[String] = None,
    environment: Option[Map[String, String]] = None,
    modelClientOptions: Option[software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions] = None,
    resultSelector: Option[Map[String, _]] = None,
    inputPath: Option[String] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    heartbeat: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateTransformJobProps =
    (new software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateTransformJobProps.Builder)
      .transformInput(transformInput)
      .transformJobName(transformJobName)
      .modelName(modelName)
      .transformOutput(transformOutput)
      .maxPayload(maxPayload.orNull)
      .role(role.orNull)
      .tags(tags.map(_.asJava).orNull)
      .batchStrategy(batchStrategy.orNull)
      .transformResources(transformResources.orNull)
      .resultPath(resultPath.orNull)
      .maxConcurrentTransforms(maxConcurrentTransforms.orNull)
      .integrationPattern(integrationPattern.orNull)
      .outputPath(outputPath.orNull)
      .comment(comment.orNull)
      .environment(environment.map(_.asJava).orNull)
      .modelClientOptions(modelClientOptions.orNull)
      .resultSelector(resultSelector.map(_.asJava).orNull)
      .inputPath(inputPath.orNull)
      .timeout(timeout.orNull)
      .heartbeat(heartbeat.orNull)
      .build()
}
