package io.burkard.cdk.services.sagemaker.cfnEndpointConfig

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CaptureContentTypeHeaderProperty {

  def apply(
    jsonContentTypes: Option[List[String]] = None,
    csvContentTypes: Option[List[String]] = None
  ): software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty =
    (new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty.Builder)
      .jsonContentTypes(jsonContentTypes.map(_.asJava).orNull)
      .csvContentTypes(csvContentTypes.map(_.asJava).orNull)
      .build()
}
