package io.burkard.cdk.services.refactorspaces

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnServiceProps {

  def apply(
    applicationIdentifier: String,
    environmentIdentifier: String,
    name: Option[String] = None,
    urlEndpoint: Option[software.amazon.awscdk.services.refactorspaces.CfnService.UrlEndpointInputProperty] = None,
    vpcId: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    endpointType: Option[String] = None,
    lambdaEndpoint: Option[software.amazon.awscdk.services.refactorspaces.CfnService.LambdaEndpointInputProperty] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnServiceProps =
    (new software.amazon.awscdk.services.refactorspaces.CfnServiceProps.Builder)
      .applicationIdentifier(applicationIdentifier)
      .environmentIdentifier(environmentIdentifier)
      .name(name.orNull)
      .urlEndpoint(urlEndpoint.orNull)
      .vpcId(vpcId.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .endpointType(endpointType.orNull)
      .lambdaEndpoint(lambdaEndpoint.orNull)
      .build()
}
