package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSMSChannel {

  def apply(
    internalResourceId: String,
    applicationId: String,
    enabled: Option[Boolean] = None,
    shortCode: Option[String] = None,
    senderId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnSMSChannel =
    software.amazon.awscdk.services.pinpoint.CfnSMSChannel.Builder
      .create(stackCtx, internalResourceId)
      .applicationId(applicationId)
      .enabled(enabled.map(Boolean.box).orNull)
      .shortCode(shortCode.orNull)
      .senderId(senderId.orNull)
      .build()
}
