package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBaiduChannelProps {

  def apply(
    applicationId: String,
    secretKey: String,
    apiKey: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps.Builder)
      .applicationId(applicationId)
      .secretKey(secretKey)
      .apiKey(apiKey)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
