package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannelProps {

  def apply(
    applicationId: String,
    clientSecret: String,
    clientId: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnADMChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnADMChannelProps.Builder)
      .applicationId(applicationId)
      .clientSecret(clientSecret)
      .clientId(clientId)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
