package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConfigurationProps {

  def apply(
    serverProperties: String,
    name: Option[String] = None,
    description: Option[String] = None,
    kafkaVersionsList: Option[List[String]] = None
  ): software.amazon.awscdk.services.msk.CfnConfigurationProps =
    (new software.amazon.awscdk.services.msk.CfnConfigurationProps.Builder)
      .serverProperties(serverProperties)
      .name(name.orNull)
      .description(description.orNull)
      .kafkaVersionsList(kafkaVersionsList.map(_.asJava).orNull)
      .build()
}
