package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDestination {

  def apply(
    internalResourceId: String,
    targetArn: String,
    destinationName: String,
    destinationPolicy: String,
    roleArn: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.logs.CfnDestination =
    software.amazon.awscdk.services.logs.CfnDestination.Builder
      .create(stackCtx, internalResourceId)
      .targetArn(targetArn)
      .destinationName(destinationName)
      .destinationPolicy(destinationPolicy)
      .roleArn(roleArn)
      .build()
}
