package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPlaceIndexProps {

  def apply(
    dataSource: String,
    indexName: String,
    description: Option[String] = None,
    dataSourceConfiguration: Option[software.amazon.awscdk.services.location.CfnPlaceIndex.DataSourceConfigurationProperty] = None,
    pricingPlan: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnPlaceIndexProps =
    (new software.amazon.awscdk.services.location.CfnPlaceIndexProps.Builder)
      .dataSource(dataSource)
      .indexName(indexName)
      .description(description.orNull)
      .dataSourceConfiguration(dataSourceConfiguration.orNull)
      .pricingPlan(pricingPlan.orNull)
      .build()
}
