package io.burkard.cdk.services.lex.cfnBotAlias

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3BucketLogDestinationProperty {

  def apply(
    logPrefix: String,
    s3BucketArn: String,
    kmsKeyArn: Option[String] = None
  ): software.amazon.awscdk.services.lex.CfnBotAlias.S3BucketLogDestinationProperty =
    (new software.amazon.awscdk.services.lex.CfnBotAlias.S3BucketLogDestinationProperty.Builder)
      .logPrefix(logPrefix)
      .s3BucketArn(s3BucketArn)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
