package io.burkard.cdk.services.kinesisanalyticsv2.cfnApplication

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CheckpointConfigurationProperty {

  def apply(
    configurationType: String,
    minPauseBetweenCheckpoints: Option[Number] = None,
    checkpointingEnabled: Option[Boolean] = None,
    checkpointInterval: Option[Number] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CheckpointConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.CheckpointConfigurationProperty.Builder)
      .configurationType(configurationType)
      .minPauseBetweenCheckpoints(minPauseBetweenCheckpoints.orNull)
      .checkpointingEnabled(checkpointingEnabled.map(Boolean.box).orNull)
      .checkpointInterval(checkpointInterval.orNull)
      .build()
}
