package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputSchemaProperty {

  def apply(
    recordFormat: software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.RecordFormatProperty,
    recordColumns: List[_],
    recordEncoding: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputSchemaProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputSchemaProperty.Builder)
      .recordFormat(recordFormat)
      .recordColumns(recordColumns.asJava)
      .recordEncoding(recordEncoding.orNull)
      .build()
}
