package io.burkard.cdk.services.inspectorv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFilter {

  def apply(
    internalResourceId: String,
    name: String,
    filterCriteria: software.amazon.awscdk.services.inspectorv2.CfnFilter.FilterCriteriaProperty,
    filterAction: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.inspectorv2.CfnFilter =
    software.amazon.awscdk.services.inspectorv2.CfnFilter.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .filterCriteria(filterCriteria)
      .filterAction(filterAction)
      .description(description.orNull)
      .build()
}
