package io.burkard.cdk.services.glue

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRegistryProps {

  def apply(
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.glue.CfnRegistryProps =
    (new software.amazon.awscdk.services.glue.CfnRegistryProps.Builder)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
