package io.burkard.cdk.services.gamelift

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScriptProps {

  def apply(
    storageLocation: software.amazon.awscdk.services.gamelift.CfnScript.S3LocationProperty,
    name: Option[String] = None,
    version: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.gamelift.CfnScriptProps =
    (new software.amazon.awscdk.services.gamelift.CfnScriptProps.Builder)
      .storageLocation(storageLocation)
      .name(name.orNull)
      .version(version.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
