package io.burkard.cdk.services.forecast

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataset {

  def apply(
    internalResourceId: String,
    domain: String,
    datasetName: String,
    schema: AnyRef,
    datasetType: String,
    tags: Option[List[_]] = None,
    dataFrequency: Option[String] = None,
    encryptionConfig: Option[AnyRef] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.forecast.CfnDataset =
    software.amazon.awscdk.services.forecast.CfnDataset.Builder
      .create(stackCtx, internalResourceId)
      .domain(domain)
      .datasetName(datasetName)
      .schema(schema)
      .datasetType(datasetType)
      .tags(tags.map(_.asJava).orNull)
      .dataFrequency(dataFrequency.orNull)
      .encryptionConfig(encryptionConfig.orNull)
      .build()
}
