package io.burkard.cdk.services.eventschemas

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRegistryPolicy {

  def apply(
    internalResourceId: String,
    policy: AnyRef,
    registryName: String,
    revisionId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.eventschemas.CfnRegistryPolicy =
    software.amazon.awscdk.services.eventschemas.CfnRegistryPolicy.Builder
      .create(stackCtx, internalResourceId)
      .policy(policy)
      .registryName(registryName)
      .revisionId(revisionId.orNull)
      .build()
}
