package io.burkard.cdk.services.efs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMountTargetProps {

  def apply(
    subnetId: String,
    fileSystemId: String,
    securityGroups: List[String],
    ipAddress: Option[String] = None
  ): software.amazon.awscdk.services.efs.CfnMountTargetProps =
    (new software.amazon.awscdk.services.efs.CfnMountTargetProps.Builder)
      .subnetId(subnetId)
      .fileSystemId(fileSystemId)
      .securityGroups(securityGroups.asJava)
      .ipAddress(ipAddress.orNull)
      .build()
}
