package io.burkard.cdk.services.ec2.cfnNetworkInsightsAccessScope

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PacketHeaderStatementRequestProperty {

  def apply(
    destinationPrefixLists: Option[List[String]] = None,
    protocols: Option[List[String]] = None,
    sourcePorts: Option[List[String]] = None,
    sourcePrefixLists: Option[List[String]] = None,
    sourceAddresses: Option[List[String]] = None,
    destinationAddresses: Option[List[String]] = None,
    destinationPorts: Option[List[String]] = None
  ): software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.PacketHeaderStatementRequestProperty =
    (new software.amazon.awscdk.services.ec2.CfnNetworkInsightsAccessScope.PacketHeaderStatementRequestProperty.Builder)
      .destinationPrefixLists(destinationPrefixLists.map(_.asJava).orNull)
      .protocols(protocols.map(_.asJava).orNull)
      .sourcePorts(sourcePorts.map(_.asJava).orNull)
      .sourcePrefixLists(sourcePrefixLists.map(_.asJava).orNull)
      .sourceAddresses(sourceAddresses.map(_.asJava).orNull)
      .destinationAddresses(destinationAddresses.map(_.asJava).orNull)
      .destinationPorts(destinationPorts.map(_.asJava).orNull)
      .build()
}
