package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SubnetProps {

  def apply(
    availabilityZone: String,
    cidrBlock: String,
    vpcId: String,
    mapPublicIpOnLaunch: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.SubnetProps =
    (new software.amazon.awscdk.services.ec2.SubnetProps.Builder)
      .availabilityZone(availabilityZone)
      .cidrBlock(cidrBlock)
      .vpcId(vpcId)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
