package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InitServiceOptions {

  def apply(
    enabled: Option[Boolean] = None,
    ensureRunning: Option[Boolean] = None,
    serviceRestartHandle: Option[software.amazon.awscdk.services.ec2.InitServiceRestartHandle] = None
  ): software.amazon.awscdk.services.ec2.InitServiceOptions =
    (new software.amazon.awscdk.services.ec2.InitServiceOptions.Builder)
      .enabled(enabled.map(Boolean.box).orNull)
      .ensureRunning(ensureRunning.map(Boolean.box).orNull)
      .serviceRestartHandle(serviceRestartHandle.orNull)
      .build()
}
