package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocalGatewayRoute {

  def apply(
    internalResourceId: String,
    localGatewayRouteTableId: String,
    localGatewayVirtualInterfaceGroupId: String,
    destinationCidrBlock: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnLocalGatewayRoute =
    software.amazon.awscdk.services.ec2.CfnLocalGatewayRoute.Builder
      .create(stackCtx, internalResourceId)
      .localGatewayRouteTableId(localGatewayRouteTableId)
      .localGatewayVirtualInterfaceGroupId(localGatewayVirtualInterfaceGroupId)
      .destinationCidrBlock(destinationCidrBlock)
      .build()
}
