package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxLustre {

  def apply(
    internalResourceId: String,
    fsxFilesystemArn: String,
    securityGroupArns: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subdirectory: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.datasync.CfnLocationFSxLustre =
    software.amazon.awscdk.services.datasync.CfnLocationFSxLustre.Builder
      .create(stackCtx, internalResourceId)
      .fsxFilesystemArn(fsxFilesystemArn)
      .securityGroupArns(securityGroupArns.asJava)
      .tags(tags.map(_.asJava).orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
