package io.burkard.cdk.services.databrew.cfnDataset

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ExcelOptionsProperty {

  def apply(
    sheetIndexes: Option[List[_ <: Number]] = None,
    sheetNames: Option[List[String]] = None,
    headerRow: Option[Boolean] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.ExcelOptionsProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.ExcelOptionsProperty.Builder)
      .sheetIndexes(sheetIndexes.map(_.asJava).orNull)
      .sheetNames(sheetNames.map(_.asJava).orNull)
      .headerRow(headerRow.map(Boolean.box).orNull)
      .build()
}
