package io.burkard.cdk.services.codepipeline.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonCloudFormationStackSetOptions {

  def apply(
    maxAccountConcurrencyPercentage: Option[Number] = None,
    stackSetRegion: Option[String] = None,
    failureTolerancePercentage: Option[Number] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CommonCloudFormationStackSetOptions =
    (new software.amazon.awscdk.services.codepipeline.actions.CommonCloudFormationStackSetOptions.Builder)
      .maxAccountConcurrencyPercentage(maxAccountConcurrencyPercentage.orNull)
      .stackSetRegion(stackSetRegion.orNull)
      .failureTolerancePercentage(failureTolerancePercentage.orNull)
      .build()
}
