package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfigProps {

  def apply(
    computePlatform: Option[String] = None,
    deploymentConfigName: Option[String] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None
  ): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps =
    (new software.amazon.awscdk.services.codedeploy.CfnDeploymentConfigProps.Builder)
      .computePlatform(computePlatform.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .build()
}
