package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroupProps {

  def apply(
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None,
    reportGroupName: Option[String] = None,
    zipExport: Option[Boolean] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None
  ): software.amazon.awscdk.services.codebuild.ReportGroupProps =
    (new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder)
      .exportBucket(exportBucket.orNull)
      .reportGroupName(reportGroupName.orNull)
      .zipExport(zipExport.map(Boolean.box).orNull)
      .removalPolicy(removalPolicy.orNull)
      .build()
}
